%macro threg(data,lny0,mu,time,failure);
   %let lny0_parameter_list=lny0_const;
   %let lny0_parameter_init=lny0_const=1%str(;);
   %let lny0_covariate_combination=lny0_const;
   %let i=1;

   %do %until (%scan(&lny0,&i) eq );

	 

     %let covariate=%scan(&lny0,&i);
	 %let lny0_parameter_list=&lny0_parameter_list lny0_&covariate;
	 %let lny0_parameter_init=&lny0_parameter_init lny0_&covariate=0%str(;);

	 %let lny0_covariate_combination=&lny0_covariate_combination+lny0_&covariate*&covariate;

	 %let i=%eval(&i+1);
   %end;


   %let mu_parameter_list=mu_const;
   %let mu_parameter_init=mu_const=1%str(;);
   %let mu_covariate_combination=mu_const;
   %let i=1;

   %do %until (%scan(&mu,&i) eq );


     %let covariate=%scan(&mu,&i);

     %let mu_parameter_list=&mu_parameter_list mu_&covariate;
	 %let mu_parameter_init=&mu_parameter_init mu_&covariate=0%str(;);

	 %let mu_covariate_combination=&mu_covariate_combination+mu_&covariate*&covariate;

	 %let i=%eval(&i+1);

   %end;


   data par1(type=est);
    keep _type_ &lny0_parameter_list &mu_parameter_list;
    _type_='parms'; &lny0_parameter_init &mu_parameter_init 
    output;
   run;



   ods html file="&data..html";

   proc nlp data=&data tech=NEWRAP inest=par1 outest=opar1
   outmodel=model cov=2 pcov phes pshort;
   max logf;
   parms &lny0_parameter_list &mu_parameter_list;

   lny0=&lny0_covariate_combination;
   mu=&mu_covariate_combination;
   d=-mu/exp(lny0);
   v=exp(-2*lny0);
   PI=constant('pi');
   s =&failure*(-.5*(log(2*PI*v*(&time**3))+(d*&time-1)**2/(v*&time)))+ (1-&failure)*log(probnorm((1-d*&time)/sqrt(v*&time))-exp(2*d/v)*probnorm(-(1+d*&time)/sqrt(v*&time)));
   logf = s;
   run;
   ods _all_ close;


%mend;
